
markup.push({

// -------------------------------------------------
// MARK: RNNoise

RNNoiseFilterBlock:
{
	"+": "BlockTemplate",
	geNodeClass: "AHRNNoiseNode",
	gxFaceModel: {
		nsClass: "H4SpeechDenoiseFace",
		gxFaceModelKeyPath: "faceModel",
	},
	gxTitle: "Speech Denoise",
	gxPopoverInfo: "AHRNNoiseNodePopover",
	gxLibraryDescription: "Remove background noise from speech",
	gxLibraryIcon: "library.speech.denoise",
	gxChildViews:
	{
		statusLight: {
			nsClass: "GXDrawView",
			gxBackPainter: {
				"+": "ImagePainter",
				gxTintColor: "ColorThemeLive3",
				gxImage: "block.speech.denoise.active",
				disabled: {
					gxTintColor: "ForeColorTheme1",
					gxImage: "block.speech.denoise",
				},
			},
			gxDisableOnKey: "voiceNotDetected",
			gxAnimateOnKey: "running",
			gxAnimationDivider: 4,  // 15fps
			gxFrameRect: "0, 10, 120, 110"
		},
	}
},
	

// MARK: popover

AHRNNoiseNodePopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Speech Denoise",
	axTitle: "Speech Denoise",
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxLayout: [ "H:|-12-[self(320)]-12-|",	// sets popover width
				"V:|-12-[self]-12-|",
				"V:|-41-[group]-16-|"
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		onOff: "PopoverOnOffSwitch",
		group: {
			"+": "GroupView.noBottomStroke",
			gxLayout:
			[
				"H:|-0-[self]-0-|",
				"V:|-13-[statusLight(36)]-13-[processMono]-10-[hintsText(30)]-0-|",

				"H:|-14-[processMono(180)]",

				"H:|-84-[statusLight(24)]-4-[lightLabel(134)]",
				"V:|-23-[lightLabel]",
				
				"H:|-16-[infoIcon(16)]-8-[hintsText]-10-|",
				"V:[processMono]-10-[infoIcon]",
			],
			gxChildViews:
			{
				// statuysLight and label are similar to Ducking block
				statusLight: {
					nsClass: "GXDrawView",
					gxBackPainter: {
						"+": "ImagePainter",
						gxTintColor: "ColorLive1",
						gxImage: "speechDenoise.active",
						disabled: {
							gxTintColor: "ColorTheme1.blockDisabled",
							gxImage: "speechDenoise",
						},
					},
					gxDisableOnKey: "voiceNotDetected",
					gxAnimateOnKey: "running",
					gxAnimationDivider: 4,  // 15fps
				},
				lightLabel: {
					"+": "LabelView",
					gxForePainter: {
						"+": "LabelFore.left",
						gxFontColor: "ColorLive1",
						gxDefaultString: "Speech Detected",
						disabled: {
							gxDefaultString: "No Speech Detected",
							gxFontColor: "ColorTheme1.blockDisabled",
						}
					},
					gxAnimationDivider: 4,  // 15fps
					gxDisableOnKey: "voiceNotDetected",
					gxAnimateOnKey: "running",
				},
				processMono: {
					"+": "CheckboxTemplate",
					gxTitle: "<checkbox/> Mono Signal Processing",
					gxValueKey: "node.processMono",
					gxDisableOnKey: "running"
				},
				infoIcon: { "+": "InfoIcon" },
				hintsText: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "Mono processing conserves CPU by down-mixing all stereo input."
				}
			}
		}
	}
},

	
	
})
